package gui;

import service.*;
import java.util.Vector;
import javax.swing.JOptionPane;
import orchestrator.Orchestrator;
import orchestrator.OrchestratorStandardImpl;
import gui.jtransitionsystem.*;
/**
 * @author Andrea
 */
public class GenericLoader 
{
	public static byte ORCHESTRATOR_STANDARD=0;
	public static byte ORCHESTRATOR_PLUS=1;
	private static byte selected_orchestrator=0;
	private static ServiceFactory serviceFactory=new ServiceFactoryImpl();
	private static TransitionSystem<SimpleState, SimpleTransition> targetService;
	private static String targetName;
	private static JTransitionSystemSimple jTargetService;
	private static Vector<TransitionSystem<SimpleState, SimpleTransition>> availableServices;
	private static Vector<String> pathAvailableServices=new Vector<String>();
	private static String pathTarget="";
	private static Vector<String> availableServicesNames;
	private static  Orchestrator orchestrator=null;
	
	
	public static void setOrchestrator(byte orchestrator){
		selected_orchestrator=orchestrator;
	}
	
	public static void setTargetService(TransitionSystem<SimpleState, SimpleTransition> TS)
	{
		targetService = TS;
		jTargetService = new JTransitionSystemSimple(targetService);
		if(checkSimulationComputable())
		{
			activateComputeButton();
		}
	}
	
	public static TransitionSystem<SimpleState, SimpleTransition> getTargetService()
	{
		return targetService;
	}
	
	public static JTransitionSystemSimple getJTargetService()
	{
		return jTargetService;
	}
	
	public static void setTargetServiceName(String name)
	{
		targetName = name;
	}
	
	public static String getTargetServiceName()
	{
		return targetName;
	}
	
	public static void addAvailableServices(Vector<TransitionSystem<SimpleState, SimpleTransition>> ts)
	{
		if(availableServices == null) availableServices = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(ts);
		else
		{
			for(int i = 0; i < ts.size(); i++)
			{
				availableServices.addElement(ts.get(i));
			}
		}
		if(checkSimulationComputable())
		{
			activateComputeButton();
		}
	}
	
	public static Vector<TransitionSystem<SimpleState, SimpleTransition>> getAvailableServices()
	{
		return availableServices;
	}
	
	public static void addAvailableServicesNames(Vector<String> names)
	{
		if(availableServicesNames == null) availableServicesNames = new Vector<String>(names);
		else
		{
			for(int i = 0; i < names.size(); i++)
			{
				availableServicesNames.addElement(names.get(i));
			}
		}
		
	}
	
	public static Vector<String> getAvailableServicesNames()
	{
		return availableServicesNames;
	}
	
	public static void resetSystem()
	{
		orchestrator=null;
		targetService=null;
		targetName="";
		jTargetService=null;
		if(availableServices != null)
			availableServices = new Vector<TransitionSystem<SimpleState, SimpleTransition>>();
		if(availableServicesNames != null)
			availableServicesNames=new Vector<String>();
		pathTarget = "";
		pathAvailableServices = new Vector<String>();
	}
	@SuppressWarnings("unchecked")
	public static void startOrchestrator() throws Exception{
		if(availableServices==null || availableServices.size()==0){
			JOptionPane.showMessageDialog(null, "No Available Service defined.\nDefine the directory containing available services.\nUnable to run Simulation", "Warning",JOptionPane.WARNING_MESSAGE);
		}
		if(targetService==null)
		{
			JOptionPane.showMessageDialog(null, "Target System not defined.\nSelect a Target System.\nUnable to run Simulation", "Warning",JOptionPane.WARNING_MESSAGE);
			return;
		}
		TransitionSystem<SimpleState, SimpleTransition> aServices[] = new TransitionSystemImpl[availableServices.size()];
		for(int i=0; i < availableServices.size(); i++)
		{
			aServices[i] = availableServices.get(i);
		}
		long a=System.currentTimeMillis();
		if(selected_orchestrator==ORCHESTRATOR_PLUS)
			orchestrator=new orchestrator.plus.OrchestratorPlusImpl(targetService,aServices,serviceFactory);
		else if(selected_orchestrator==ORCHESTRATOR_STANDARD)
			orchestrator=new OrchestratorStandardImpl(targetService,aServices);
		long b=System.currentTimeMillis();
		System.out.println("time in msec:"+(b-a));

		MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(false);
		MainFrame.getInstance().getStateDescriptionPanel().getStopSimulation().setEnabled(true);
		MainFrame.getInstance().getStateDescriptionPanel().getActionButton().setEnabled(true);

	}
	public static void stopOrchestrator(){
		orchestrator=null;
		MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(true);
		MainFrame.getInstance().getStateDescriptionPanel().getStopSimulation().setEnabled(false);
		MainFrame.getInstance().getStateDescriptionPanel().getActionButton().setEnabled(false);
	}
	public static boolean orchestratorIsStarted(){
		if(orchestrator==null)
			return false;
		else return true;
	}
	public static TransitionSystem<ComposedState,ComposedTransition> getCompositionTs() throws Exception{
		if(orchestrator==null)
			throw new Exception("Orchestrator not started");
		else return orchestrator.getCompositionTs();
	}
	public static void doAction(SimpleTransition a) throws Exception{
		if(orchestrator==null)
			throw new Exception("Orchestrator not started");
		orchestrator.doAction(a);
		jTargetService.executeAction(a);
	}
	public static SimpleState getCurrentTargetState() throws Exception
	{
		if(orchestrator == null)
			throw new Exception("Orchestrator not started");
		return orchestrator.getCurrentTargetState();
	}
	public static ComposedState getCurrentAvailableState()throws Exception
	{
		if(orchestrator == null)
			throw new Exception("Orchestrator not started");
		return orchestrator.getCurrentServicesState();		
	}
	@SuppressWarnings("unchecked")
	public static TransitionSystem<SimpleState, SimpleTransition> getLastTSExecutedAction()throws Exception
	{
		if(orchestrator == null)
			throw new Exception("Orchestrator not started");
		return (TransitionSystem<SimpleState, SimpleTransition>) orchestrator.getLastExecutedAction().getService();	
	}
	public static Vector<String[]> getCompositionDataToExport() throws Exception{
		if(orchestrator == null)
			throw new Exception("Orchestrator not started");
		return orchestrator.getCompositionDataToExport();		
	}
	public static Vector<String[]> getSimulationDataToExport() throws Exception{
		if(orchestrator == null)
			throw new Exception("Orchestrator not started");
		return orchestrator.getSimulationDataToExport();	
	}
	
	public static TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() throws Exception
	{
		if(orchestrator == null) throw new Exception("Orchestrator not started");
		return orchestrator.getAsyncProduct();
	}
	
	private static boolean checkSimulationComputable()
	{
		if(targetService!=null && availableServices!=null)
		{
			if(availableServices.size() > 0)
				return true;
		}
		return false;
	}
	private static void activateComputeButton()
	{
		MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(true);
	}

	public static void setAvailableServices(Vector<TransitionSystem<SimpleState, SimpleTransition>> ts)
	{
		if(availableServices == null) availableServices = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(ts);
		else
		{
			availableServices.removeAllElements();
			availableServices.addAll(ts);
			
		}
		if(checkSimulationComputable())
		{
			activateComputeButton();
		}
	}

	
	public static Vector<String> getPathAvailableService(){
		return pathAvailableServices;
	}

	
	public static String getPathTarget(){
		return pathTarget;
	}

	public static void setAvailableServicesPath(Vector<String> pathAvailableServices) 
	{
		if(GenericLoader.pathAvailableServices == null) GenericLoader.pathAvailableServices = new Vector<String>(pathAvailableServices);
		else
		{
			for(int i = 0; i < pathAvailableServices.size(); i++)
			{
				GenericLoader.pathAvailableServices.addElement(pathAvailableServices.get(i));
			}
		}
	}


	public static void setTargetServicePath(String absolutePath) {
		GenericLoader.pathTarget=absolutePath;
		
	}

	
	public static void setAvailableServicesNames(Vector<String> tssNames) {
		GenericLoader.availableServicesNames=tssNames;
		
	}

}
